#include <iostream>
#include <unordered_map>
#include <cmath>
#include <vector>
#include <map>
#include <algorithm>
#include <string>
#include <queue>
#include <fstream>
#include <random>
#include <Windows.h>
#include <stack>

#define _SILENCE_STDEXT_HASH_UPPER_BOUND_DEPRECATION_WARNING

#ifndef max
#define max(a,b)            (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)            (((a) < (b)) ? (a) : (b))
#endif

std::vector<long long> left;
std::vector<long long> right;

std::unordered_map<int, long long> memo;

int trav(std::vector<long long>& arr, long long currs, int i) {
	if (i >= arr.size()) return 0;

	if (currs + arr[i] < left[i]) {
		left[i] = currs + arr[i];
		long long p1 = trav(arr, currs + arr[i], i + 1) + arr[i];
		long long p2 = trav(arr, currs + arr[i], i + 2) + arr[i];

		if (p1 <= p2) {
			right[i] = p1;
			return memo[i] = p1;
		}
		else {
			right[i] = p2;
			return memo[i] = p2;
		}
	}
	else {
		if (memo[i]) return memo[i];

		long long p1 = trav(arr, currs + arr[i], i + 1) + arr[i];
		long long p2 = trav(arr, currs + arr[i], i + 2) + arr[i];

		if (p1 <= p2) {
			right[i] = p1;
			return memo[i] = p1;
		}
		else {
			right[i] = p2;
			return memo[i] = p2;
		}
	}
}

int main() {
	std::ios_base::sync_with_stdio(false);
	std::cin.tie(0);
	std::cout.tie(0);
	long long n;
	std::cin >> n;

	std::vector<int> p(n);
	for (int i = 0; i < n; i++) {
		std::cin >> p[i];
	}

	std::unordered_map<int, std::unordered_map<int, int>> memo;

	int q;
	std::cin >> q;
	for (int i = 0; i < q; i++) {
		int m, j;
		std::cin >> m >> j;
		m--;
		if (p[m] == n) {
			std::cout << log2(n) + 1 << std::endl;
			continue;
		}
		int k = 2;
		int it = 1;
		int larger = 0;
		if (memo[m].size() == 0) {
			bool eval = false;
			int res = 0;

			while (k <= n) {
				//std::cout << k << " " << it << " " << larger << std::endl;
				if (k > p[m]) {
					res = it;  break;
				}
				//std::cout << k << "-" << it << " " << larger << std::endl;
				int r = m % k;
				if (r < k / 2) {
					//right side
					int start = (m / k) * k + k / 2;
					for (int t = 0; t < k / 2; t++) {
						if (p[start + t] > p[m]) larger++;
					}
				}
				else {
					//left side
					int start = (m / k) * k;
					for (int t = 0; t < k / 2; t++) {
						if (p[start + t] > p[m]) larger++;
					}
				}
				if (larger > j && !eval) {
					res = it;
					eval = true;
				}
				//std::cout << k << "/" << it << " " << larger << " " << res << std::endl;
				memo[m][k] = larger;
				it++;
				k *= 2;
			}
			std::cout << res << std::endl;
		}
		else {
			while (k <= n) {
				//std::cout << k << " " << memo[m][k] << std::endl;
				if (k > p[m]) break;
				if (memo[m][k] > j) break;
				it++;
				k *= 2;
			}
			std::cout << it << std::endl;
		}
	}

	return 1;
}